package Plugins::PlayHistory::Menu;

use strict;
use base qw(Slim::Menu::TrackInfo);

use Scalar::Util qw(blessed);

use Plugins::PlayHistory::Plugin;
use Slim::Utils::Log;
#use Slim::Utils::Strings qw(cstring);

my $log = logger('plugin.playhistory');

sub name { 'PLUGIN_PLAYHISTORY' }

sub menu {
	my ( $class, $client, $id, $tags ) = @_;
	$tags ||= {};
	
	my $remoteMeta = Plugins::PlayHistory::Plugin->getPlayedItem($id);
	
	my $url = $remoteMeta->{url};
	
	my $track = Slim::Schema->objectForUrl( {
		url => $url,
		create => 1,
	} );
	
	# Function to add menu items
	my $addItem = sub {
		my ( $ref, $items ) = @_;
		
		if ( defined $ref->{func} ) {
			
			# skip jive-only items for non-jive UIs
			return if $ref->{menuMode} && !$tags->{menuMode};
			
			my $item = eval { $ref->{func}->( $client, $url, $track, $remoteMeta, $tags ) };
			if ( $@ ) {
				$log->error( 'PlayHistory menu item "' . $ref->{name} . '" failed: ' . $@ );
				return;
			}
			
			return unless defined $item;
			
			if ( ref $item eq 'ARRAY' ) {
				if ( scalar @{$item} ) {
					push @{$items}, @{$item};
				}
			}
			elsif ( ref $item eq 'HASH' ) {
				return if $ref->{menuMode} && !$tags->{menuMode};
				if ( scalar keys %{$item} ) {
					push @{$items}, $item;
				}
			}
			else {
				$log->error( 'PlayHistory menu item "' . $ref->{name} . '" failed: not an arrayref or hashref' );
			}				
		}
	};
	
	# Now run the order, which generates all the items we need
	my $items = [];
	
	my $infoOrdering = $class->getInfoOrdering;
	
	for my $ref ( @{ $infoOrdering } ) {
		# Skip items with a defined parent, they are handled
		# as children below
		next if $ref->{parent};
		
		# Add the item
		$addItem->( $ref, $items );
		
		# Look for children of this item
		my @children = grep {
			$_->{parent} && $_->{parent} eq $ref->{name}
		} @{ $infoOrdering };
		
		if ( @children ) {
			my $subitems = $items->[-1]->{items} = [];
			
			for my $child ( @children ) {
				$addItem->( $child, $subitems );
			}
		}
	}
	
	# Remove distinct play/add items and add a single playable URL
	if ($track->url) {
		$items = [ grep {
			($_->{jive} && $_->{jive}->{actions}) ? undef : $_
		} @$items ];
		
		unshift @$items, {
			name => $remoteMeta->{remote_title} || Slim::Music::TitleFormatter::infoFormat($track, '', 'TITLE - ARTIST', $remoteMeta),
			type => 'audio',
			url => $url
		};
	}
	
	return {
		name  => $track->title || Slim::Music::Info::getCurrentTitle( $client, $url, 1 ),
		type  => 'opml',
		items => $items,
		play  => $url,
		cover => $remoteMeta->{artwork_url} || $remoteMeta->{cover} || $remoteMeta->{icon} || '/music/' . ($remoteMeta->{coverid} || $track->coverid || 0) . '/cover.jpg',
		menuComplete => 1,
	};
}

# XXX - Slim::Menu::TrackInfo isn't cleanly OO. Need to hack it to get the correct menu.
sub getInfoOrdering {
	return Slim::Menu::TrackInfo->getInfoOrdering();
=pod
	my $class = shift;
	
	my %seen;
	foreach ( @{ Slim::Menu::TrackInfo->getInfoOrdering() } ) {
		my $name = delete $_->{name};
		$seen{$name}++;
		$class->registerInfoProvider($name => %$_);
	}

	$class->registerInfoProvider( 'searchArtist' => (
		after => 'middle',
		func  => sub {
			my ( $client, $url, $track, $remoteMeta, $tags ) = @_;
			
			my $artist = $remoteMeta->{artist} || $track->artistName;
			
			return {
				name => cstring($client, 'SEARCHFOR') . " '" . $artist . "'",
				url => sub {
					my ($client, $cb, $params, $artist) = @_;
					$cb->( Slim::Menu::GlobalSearch->menu($client, {
						search => $artist
					}) );
				},
				passthrough => [ $artist ]
			}
		},
		menuMode => 1,
	) );
	
	$class->registerInfoProvider( 'searchTrack' => (
		after => 'searchArtist',
		func  => sub {
			my ( $client, $url, $track, $remoteMeta, $tags ) = @_;
			
			my $name = $remoteMeta->{track} || $track->name;
			
			return {
				name => cstring($client, 'SEARCHFOR') . " '" . $name . "'",
				url => sub {
					my ($client, $cb, $params, $track) = @_;
					$cb->( Slim::Menu::GlobalSearch->menu($client, {
						search => $track
					}) );
				},
				passthrough => [ $name ]
			}
		},
		menuMode => 1,
	) );
	
	return $class->SUPER::getInfoOrdering();
=cut
}

1;